$title: (1) Split GTAP Land Use to River Basins

*--------------------------------------------------*
*                                                  *
*            Global Trade Analysis Project         *
*                GTAP Water Database               *
*                     SplitLand                    *
*  ch 1: Splitting GTAP Land Use by River Basin   *
*                                                  *
*--------------------------------------------------*


parameter
  HVST     Harvested area for crops in 2011 in hectares,
  PRDN     Production of crops in 2011 in metric tons,
  FRST     Forest Land Cover in 2011 in hectares,
  PSTR     Pasture Land Cover in 2011 in hectares,
  CLND     Crop Land in 2011 in hectares,

  hvst_miss      check hvst
  prod_miss      check prod
  frst_miss      check frst
  pstr_miss      check pstr
  clnd_miss      check clnd
  zhvst(a,b,c,r) share of river basin b in harvested area of crop c in region r
  zprdn(a,b,c,r) share of river basin b in production of crop c in region r
  zfrst(a,b,r)   share of river basin b in forest land
  zpstr(a,b,r)   share of river basin b in pasture land
  zclnd(a,b,r)   share of river basin b in cropland
;


*    ! Initial value for land use 2011 !
*--------------------------------------------------*

*   ! Find the share of river basins in each aez from Siebert data !
zhvst(a,b,c,r)$sum(rb,hvst0(r,rb,a,c)) =
         hvst0(r,b,a,c)/sum(rb,hvst0(r,rb,a,c));
zprdn(a,b,c,r)$sum(rb,prod0(r,rb,a,c)) =
         prod0(r,b,a,c)/sum(rb,prod0(r,rb,a,c));
zfrst(a,b,r)$sum(rb,cover2000(r,rb,a,"forest")) =
         cover2000(r,b,a,"forest")/sum(rb,cover2000(r,rb,a,"forest"));
zpstr(a,b,r)$sum(rb,cover2000(r,rb,a,"livestock")) =
         cover2000(r,b,a,"livestock")/sum(rb,cover2000(r,rb,a,"livestock"));
zclnd(a,b,r)$sum(rb,cover2000(r,rb,a,"crops")) =
         cover2000(r,b,a,"crops")/sum(rb,cover2000(r,rb,a,"crops"));

*    ! Dissaggragate by river basin !
*--------------------------------------------------*
hvst(a,b,c,r) = zhvst(a,b,c,r)*hvst11(a,c,r);
prdn(a,b,c,r) = zprdn(a,b,c,r)*prod11(a,c,r);

frst(a,b,r) =  zfrst(a,b,r) * lcov11(a,"forest",r);
pstr(a,b,r) =  zpstr(a,b,r) * lcov11(a,"pastureland",r);
clnd(a,b,r) =  zclnd(a,b,r) * lcov11(a,"cropland",r);

*    ! If no river basin information in 2000 !
*--------------------------------------------------*
hvst(a,'rb500',c,r)$(hvst11(a,c,r) and not sum(rb,hvst0(r,rb,a,c))) =
     hvst11(a,c,r);
prdn(a,'rb500',c,r)$(prod11(a,c,r) and not sum(rb,prod0(r,rb,a,c))) =
     prod11(a,c,r);

frst(a,'rb500',r)$(lcov11(a,"forest",r) and not sum(rb,cover2000(r,rb,a,"forest")))=
      lcov11(a,"forest",r);
pstr(a,'rb500',r)$(lcov11(a,"pastureland",r) and not sum(rb,cover2000(r,rb,a,"livestock")))=
      lcov11(a,"pastureland",r);
clnd(a,'rb500',r)$(lcov11(a,"cropland",r) and not sum(rb,cover2000(r,rb,a,"crops")))=
      lcov11(a,"cropland",r);


*   ! count # river basin whithout information in 2000!
*--------------------------------------------------*
hvst_miss(a,c,r)$(hvst11(a,c,r) and not sum(rb,hvst0(r,rb,a,c))) = 1;
prod_miss(a,c,r)$(prod11(a,c,r) and not sum(rb,prod0(r,rb,a,c))) = 1;

frst_miss(a,b,r)$(lcov11(a,"forest",r) and not sum(rb,cover2000(r,rb,a,"forest"))) =-1;
pstr_miss(a,b,r)$(lcov11(a,"pastureland",r) and not sum(rb,cover2000(r,rb,a,"livestock"))) =-1;
clnd_miss(a,b,r)$(lcov11(a,"cropland",r) and not sum(rb,cover2000(r,rb,a,"crops"))) =-1;

hvst(a,b,c,r)$(not hvst(a,b,c,r)) = eps;
prdn(a,b,c,r)$(not prdn(a,b,c,r)) = eps;
frst(a,b,r)  $(not frst(a,b,r))   = eps;
pstr(a,b,r)  $(not pstr(a,b,r))   = eps;
clnd(a,b,r)  $(not clnd(a,b,r))   = eps;
